# FAFO LABS Paper Trading Chrome Extension

> Paper trade on any crypto platform using your FAFO LABS simulator. Overlay your positions, orders, and P&L directly on DexScreener, Birdeye, Jupiter, Binance & more.

## Features

- 🪙 **Auto Token Detection** — Automatically detects the token you're viewing from the URL
- 📊 **Use Their Charts** — Trade on top of DexScreener, Birdeye, Jupiter, Binance charts
- 💰 **Paper Balance** — Track your simulated balance and P&L in real-time
- 📋 **Open Positions** — View and close positions right from the overlay panel
- 📑 **Limit Orders** — Set limit buy/sell and stop-loss orders
- 📜 **Trade History** — View your recent closed trades with P&L
- 🎨 **Premium UI** — Dark glassmorphism floating panel with drag support

## Supported Platforms

| Platform | URL Pattern | Token Extraction |
|----------|-------------|------------------|
| DexScreener | `dexscreener.com/solana/*` | From URL path |
| Birdeye | `birdeye.so/token/*` | From URL path |
| Jupiter | `jup.ag/swap/*` | From URL path |
| Binance | `binance.com/*/trade/*` | From URL path |
| Any Site | Manual entry | Paste token address |

## Installation (Developer Mode)

1. Open Chrome and go to `chrome://extensions/`
2. Enable **Developer mode** (toggle in top-right)
3. Click **Load unpacked**
4. Select this folder (`fafo-paper-trading-ext/`)
5. The FAFO LABS icon will appear in your toolbar

## Setup

1. **Start your backend** (must be running):
   ```bash
   cd ~/jup-trading-simulator
   uvicorn backend.app.main:app --reload --host 0.0.0.0 --port 8000
   ```

2. **Click the extension icon** in your toolbar
3. **Configure server URL** (if not localhost): Click ⚙ Server Settings
4. **Login** with your trader username & password
5. **Visit any supported platform** — the trading panel appears automatically!

## Usage

1. Navigate to DexScreener, Birdeye, Jupiter, or Binance
2. Browse to any token page
3. The floating FAFO LABS panel appears in bottom-right
4. Enter USD amount and click **BUY** to open a paper position
5. View your positions in the **Positions** tab
6. Click **CLOSE** to close a position and realize P&L
7. Drag the panel header to reposition it
8. Click ▼ to collapse the panel

## Architecture

```
popup/          → Extension popup (login, dashboard, settings)
lib/            → Shared libraries (API client, platform detection, utils)
content.js      → Content script injected into trading platforms
content.css     → Floating panel styles
background.js   → Service worker (auth state, API proxy)
manifest.json   → Chrome Extension Manifest V3
```

## Future Plans

- Deploy backend to VPS with custom domain
- Add WebSocket real-time price updates
- Candlestick chart markers for entry/exit points
- Notification alerts for order execution
- Multi-chain support
